// Advanced Tab Set //

function ItemSet(x, y, w, h, iw, ih, style)
{
	if (!this instanceof ItemSet) return new ItemSet(x, y, w, h, style);
	
	this.x = x; this.y = y;
	this.w = w; this.h = h;
	this.iw = iw; this.ih = ih;
	this.H = Math.floor(this.h/this.ih);
	this.W = Math.floor(this.w/this.iw);
	this.w += this.W*3 + 3;
	this.h += this.H*3 + 3;
	this.style = style || new Style();
	this.items = [];
	this.maxItems = this.H*this.W;
	this.index = 0;
	this.inc = 0;
	this.topInc = 0;
	this.selected = 0;
	// On itemsets items click //
	this.onClick = function(){};
	// Used to change itemset //
	var IS = this;
	this.downButton = new DynaImage(this.style.downArrow);
	this.downButton.onClick = function() { IS.incrementItemSet(); }
	this.upButton = new DynaImage(this.style.upArrow);
	this.upButton.onClick = function() { IS.decrementItemSet(); };
	this.rightButton = new DynaImage(this.style.upArrow);
	this.rightButton.rotate(1.5*Math.PI);
	this.rightButton.onClick = function() { IS.incrementItem(); };
	this.leftButton = new DynaImage(this.style.upArrow);
	this.leftButton.rotate(0.5*Math.PI);
	this.leftButton.onClick = function() { IS.decrementItem(); };
	this.h += 2+this.leftButton.height;
	// rendering //
	this.postRender = function(){};
	this.preRender = function(){};
}

// property is optional; indicates a certain property to use in an array of objects or arrays.
ItemSet.prototype.addItemSet = function(name, array, property)
{
	this.items.push({name: name, array: array, index: 0, property: property});
}

ItemSet.prototype.incrementItemSet = function() { if (this.index < this.items.length-1) this.index++; this.topInc = 0; };
ItemSet.prototype.decrementItemSet = function() { if (this.index > 0) this.index--; this.topInc = 0; };
ItemSet.prototype.incrementItem = function() { if (this.topInc < this.items[this.index].array.length - this.maxItems) this.topInc++; };
ItemSet.prototype.decrementItem = function() { if (this.topInc > 0) this.topInc--; };

ItemSet.prototype.blit = function()
{
	this.preRender();
	var Set = this.items[this.index];
	this.style.window.drawWindow(this.x, this.y, this.w, this.h);
	this.style.drawText(this.x + this.w/2-this.style.font.getStringWidth(Set.name)/2, this.y, Set.name);
	if (this.index != this.items.length-1) this.downButton.blit(this.x, this.y);
	if (this.index != 0) this.upButton.blit(this.x+this.w-this.upButton.width, this.y);
	
	this.inc = this.topInc;
	for (var C = 0; C < this.H; C++)
	{
		for (var R = 0; R < this.W; R++)
		{	
			if (this.inc > Set.array.length-1) break;
			if (this.inc > this.maxItems) break;
			
			if (Set.property != undefined) var Item = Set.array[this.inc][Set.property];
			else Item = Set.array[this.inc];
			
			var newX = this.x + 3 + R*(this.iw+3);
			var newY = this.y + 24 + C*(this.ih+3);
			OutlinedRectangle(newX-1, newY-1, this.iw+2, this.ih+2, Colors.DGray);
			
			// If Spriteset, blit a frames' image //
			if (IsSpriteset(Item)) Item.images[0].blit(newX, newY);
			
			// If image, blit it //
			if (IsImage(Item)) Item.blit(newX, newY);
			
			// If null, blit null gfx //
			if (Item == null)
			{
				RadLib.nullImage.blit(newX+this.iw/2-RadLib.nullImage.width/2, newY+this.ih/2-RadLib.nullImage.height/2);
			}
			
			if (Cursor.x > newX && Cursor.y > newY && Cursor.x < newX+this.iw && Cursor.y < newY + this.ih)
			{
				this.selected = this.inc;
				if (IsMouseButtonPressed(MOUSE_LEFT) && Cursor.leftIdle)
				{
					Cursor.leftIdle = false;
					this.onClick();
				}
			}
			this.inc++;
		}
	}
	
	if (this.topInc + this.maxItems < Set.array.length)
		this.rightButton.blit(this.x+this.w-this.rightButton.width-4, this.y+this.h - this.rightButton.height-2);
	
	if (this.topInc > 0) this.leftButton.blit(this.x+4, this.y+this.h - this.leftButton.height-2);
	
	this.postRender();
	
	while (AreKeysLeft())
	{
		switch (GetKey())
		{
			case KEY_UP: this.decrementItemSet(); break;
			case KEY_DOWN: this.incrementItemSet(); break;
			case KEY_RIGHT: this.incrementItem(); break;
			case KEY_LEFT: this.decrementItem(); break;
		}
	}
}

function IsSpriteset(object)
{
	if (object == null) return false;
	return (object.images != undefined);
}

function IsImage(object)
{
	if (object == null) return false;
	return (object.width != undefined);
}

function IsSound(object)
{
	if (object == null) return false;
	return (object.play != undefined);
}